
<?php $__env->startSection('content'); ?>
<?php echo $__env->make($activeTemplate . 'partials.breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <section class="dashboard-section pt-80">
        <div class="container">
            <div class="pb-80">
                <div class="message__chatbox bg--section">
                    <div class="message__chatbox__header">
                    	<h5 class="title">
	                    	<?php if($my_ticket->status == 0): ?>
		                        <span class="badge badge--success"><?php echo app('translator')->get('Open'); ?></span>
		                    <?php elseif($my_ticket->status == 1): ?>
		                        <span class="badge badge--primary"><?php echo app('translator')->get('Answered'); ?></span>
		                    <?php elseif($my_ticket->status == 2): ?>
		                        <span class="badge badge--warning"><?php echo app('translator')->get('Customer Reply'); ?></span>
		                    <?php elseif($my_ticket->status == 3): ?>
		                        <span class="badge badge--danger"><?php echo app('translator')->get('Closed'); ?></span>
		                    <?php endif; ?>
                        	<?php echo app('translator')->get('Ticket Id'); ?> : <span class="text--base">[#<?php echo e($my_ticket->ticket); ?>] <?php echo e($my_ticket->subject); ?></span></h5>
                    </div>
                    <div class="message__chatbox__body">
                    <?php if($my_ticket->status != 4): ?>
                        <form class="message__chatbox__form row" method="post" action="<?php echo e(route('ticket.reply', $my_ticket->id)); ?>" enctype="multipart/form-data">
                        	<?php echo csrf_field(); ?>
                        	<input type="hidden" name="replayTicket" value="1">
                            <div class="form--group col-sm-12">
                                <textarea class="form-control form--control" name="message" placeholder="<?php echo app('translator')->get('Enter Message'); ?>" required=""></textarea>
                            </div>
                            <div class="form--group col-sm-12">
                                <div class="d-flex">
                                    <div class="left-group col p-0">
                                        <label for="file" class="cmn--label text--title"><?php echo app('translator')->get('Attachments'); ?></label>
                                        <input type="file" class="overflow-hidden form-control form--control mb-2" name="attachments[]" id="file">
                                    </div>
                                       
                                    <div class="add-area">
                                        <label class="cmn--label text--title d-block">&nbsp;</label>
                                        <button class="cmn--btn btn--sm bg--primary form--control ms-2 ms-md-4 addFile" type="button"><i class="las la-plus"></i></button>
                                    </div>
                                </div>

                                <div id="fileUploadsContainer"></div>
                                <span class="info fs--14"><?php echo app('translator')->get('Allowed File Extensions'); ?>: .<?php echo app('translator')->get('jpg'); ?>, .<?php echo app('translator')->get('jpeg'); ?>, .<?php echo app('translator')->get('png'); ?>, .<?php echo app('translator')->get('pdf'); ?>, .<?php echo app('translator')->get('doc'); ?>, .<?php echo app('translator')->get('docx'); ?></span>

                            </div>
                            <div class="form--group col-sm-12 mt-2 mb-0">
                                <button type="submit" class="cmn--btn btn--lg"><?php echo app('translator')->get('Send Message'); ?></button>
                            </div>
                        </form>
                    <?php endif; ?>
                    </div>
                </div>
            </div>


            <div class="pb-80">
                <div class="message__chatbox bg--section">
                    <div class="message__chatbox__body">
                        <ul class="reply-message-area">
                            <?php $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
		                        <li>
			                    <?php if($message->admin_id == 0): ?>
			                            <div class="reply-item">
			                                <div class="name-area">
			                                    <h6 class="title"><?php echo e(__($message->ticket->name)); ?></h6>
			                                </div>
			                                <div class="content-area">
			                                    <span class="meta-date">
			                                        <?php echo app('translator')->get('Posted on'); ?> <span class="cl-theme"><?php echo e($message->created_at->format('l, dS F Y @ H:i')); ?></span>
			                                    </span>
			                                    <p>
			                                        <?php echo e(__($message->message)); ?>

			                                    </p>
			                                     <?php if($message->attachments()->count() > 0): ?>
			                                        <div class="mt-2">
			                                            <?php $__currentLoopData = $message->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=> $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			                                                <a href="<?php echo e(route('ticket.download',encrypt($image->id))); ?>" class="mr-3"><i class="fa fa-file"></i>  <?php echo app('translator')->get('Attachment'); ?> <?php echo e(++$k); ?> </a>
			                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			                                        </div>
			                                    <?php endif; ?>
			                                </div>
			                            </div>
			                        <?php else: ?>
			                            <ul>
			                                <li>
			                                    <div class="reply-item">
			                                        <div class="name-area">
			                                            <div class="reply-thumb">
			                                                <img src="<?php echo e(getImage('assets/admin/images/profile/'. $message->admin->image, '400x400')); ?>" alt="<?php echo app('translator')->get('Admin Image'); ?>">
			                                            </div>
			                                            <h6 class="title"><?php echo e(__($message->admin->name)); ?></h6>
			                                        </div>
			                                        <div class="content-area">
			                                            <span class="meta-date">
			                                                <?php echo app('translator')->get('Posted on'); ?>, <span class="cl-theme"><?php echo e($message->created_at->format('l, dS F Y @ H:i')); ?></span>
			                                            </span>
			                                            <p>
			                                                <?php echo e(__($message->message)); ?>

			                                            </p>
			                                            <?php if($message->attachments()->count() > 0): ?>
			                                                <div class="mt-2">
			                                                    <?php $__currentLoopData = $message->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=> $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			                                                        <a href="<?php echo e(route('ticket.download',encrypt($image->id))); ?>" class="mr-3"><i class="fa fa-file"></i>  <?php echo app('translator')->get('Attachment'); ?> <?php echo e(++$k); ?> </a>
			                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			                                                </div>
			                                            <?php endif; ?>
			                                        </div>
			                                    </div>
			                                </li>
			                            </ul>
			                        </li>
		                        <?php endif; ?>
		                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        (function ($) {
            "use strict";
            $('.addFile').on('click',function(){
                $("#fileUploadsContainer").append(
                    `<div class="d-flex removeFile">
                        <div class="left-group col p-0">
                            <label for="file" class="cmn--label text--title"><?php echo app('translator')->get('Attachments'); ?></label>
                            <input type="file" class="overflow-hidden form-control form--control mb-2" name="attachments[]" id="file">
                        </div>
                           
                        <div class="add-area">
                            <label class="cmn--label text--title d-block">&nbsp;</label>
                            <button class="cmn--btn btn--sm bg--danger form--control ms-2 ms-md-4 remove-btn" type="button"><i class="las la-times"></i></button>
                        </div>
                    </div>`
                )
            });
            $(document).on('click','.remove-btn',function(){
                $(this).closest('.removeFile').remove();
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make($activeTemplate.'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/highogyr/public_html/core/resources/views/templates/basic/ticket.blade.php ENDPATH**/ ?>